<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
if(!class_exists('devvn_hotline')){
class devvn_hotline {
	public $_optionName = 'hotline_options';
	public $_optionGroup = 'hotline-options-group';
	public $_defaultOptions = array(
	    'avatar' 	=>	'',
	    'active' 	=>	'0',
		'text'		=>	'',
		'scrolltop'	=>	'200'
	);
	function __construct() {
		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		add_action( 'admin_init', array( $this, 'register_mysettings') );
		
		add_option( $this->_optionName, $this->_defaultOptions );
		
		add_action('wp_footer', array($this, 'hotline_to_footer'));
				
	}
	function admin_menu() {
		add_options_page(
			__('Hotline','devvn'), 
			__('Hotline','devvn'),
			'manage_options',
			'hotline',
			array(
				$this,
				'hotline_setting'
			)
		);
	}
	
	function register_mysettings() {
		register_setting( $this->_optionGroup, $this->_optionName );
	}
	function  hotline_setting() {
		wp_enqueue_media();
		?>
		<div class="wrap">
			<h1>Cài đặt Hotline</h1>
			<form method="post" action="options.php" novalidate="novalidate">
			<?php
			settings_fields( $this->_optionGroup );
			$hotline_options = wp_parse_args(get_option($this->_optionName),$this->_defaultOptions);
			?>
				<table class="form-table">
					<tbody>
						<tr>
							<th scope="row"><label for="activeplugin">Active Hotline</label></th>
							<td>
								<label><input type="radio" name="<?=$this->_optionName?>[active]" <?php checked('1',$hotline_options['active'])?> value="1" />Yes</label>
			                    <label><input type="radio" name="<?=$this->_optionName?>[active]" <?php checked('0',$hotline_options['active'])?> value="0" />No</label>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="activeplugin">Upload Avatar</label><br>
								<small>(Kích thước đẹp là 100x100px)</small>
							</th>
							<td>
								<div class="svl-upload-image <?php echo ($hotline_options['avatar'])?'has-image':'';?>">						
								  <div class="view-has-value">
								    <input type="hidden" class="clone_delete" name="<?=$this->_optionName?>[avatar]" id="<?=$this->_optionName?>[avatar]" value="<?php echo $hotline_options['avatar'];?>"/>								
									<img src="<?php echo wp_get_attachment_url( $hotline_options['avatar'] );?>" class="image_view pins_img"/>			
								    <a href="#" class="svl-delete-image">x</a>
								  </div>
								  <div class="hidden-has-value"><input type="button" class="ireel-upload button" value="<?php _e( 'Chọn ảnh', 'devvn' )?>" /></div>
								</div>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="html_code_r">Content</label><br>
								<small>(Có thể nhập HTML)</small>
							</th>
							<td>
								<textarea class="regular-text" rows="5" cols="50" name="<?=$this->_optionName?>[text]" id="html_code_r"><?php echo esc_textarea($hotline_options['text'])?></textarea>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="scrolltop">Scroll Top To Show</label></th>
							<td>
								<input class="regular-text" type="number" name="<?=$this->_optionName?>[scrolltop]" id="scrolltop" value="<?php echo sanitize_text_field($hotline_options['scrolltop'])?>"/>
							</td>
						</tr>		

										
						<?php do_settings_fields('hotline-options-group', 'default'); ?>
					</tbody>
				</table>
				<?php do_settings_sections('hotline-options-group', 'default'); ?>
				<?php submit_button();?>
			</form>
		</div>
		<style>
		.svl-upload-image {
		    display: inline-block;
    		max-width: 350px;
		}
		.svl-upload-image img{	    
		    max-width: 100%;
		    height: auto;
		}
		.view-has-value {
		    display: none;
		    position: relative;
		}
		
		.has-image .view-has-value {
		    display: block;
		}
		
		.hidden-has-value {
		    display: block;
		}
		
		.has-image .hidden-has-value {
		    display: none;
		}
		
		a.svl-delete-image {
		    position: absolute;
		    top: 0;
		    right: 0;
		    color: #fff;
		    background: #000;
		    display: block;
		    width: 20px;
		    height: 20px;
		    text-align: center;
		    text-decoration: none;
		}
		</style>
		<script type="text/javascript">
		(function($){
		  //image upload
		  $('body').on('click','.ireel-upload',function(e){
		    // Prevents the default action from occuring.
		    e.preventDefault();
		    var thisUpload = $(this).parents('.svl-upload-image');
		    // Sets up the media library frame
		    meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
		      title: 'Upload Image',
		      button: { text:  'Upload Image' },
		      library: { type: 'image' },
		      multiple: false
		    });
		    // Runs when an image is selected.
		    meta_image_frame.on('select', function(){
		      // Grabs the attachment selection and creates a JSON representation of the model.
		      var media_attachment = meta_image_frame.state().get('selection').first().toJSON();
		      // Sends the attachment URL to our custom image input field.
		
		      if ( media_attachment.id ) {					
		        var attachment_image = media_attachment.sizes && media_attachment.sizes.thumbnail ? media_attachment.sizes.thumbnail.url : media_attachment.url;
		
		        thisUpload.addClass('has-image');
		        thisUpload.find('input[type="hidden"]').val(media_attachment.id);
		        thisUpload.find('img.image_view').attr('src',media_attachment.url);
		      }
		    });
		    // Opens the media library frame.
		    meta_image_frame.open();
		  });	
		
		
		  $('body').on('click','.svl-delete-image',function(){
		    var parentDiv = $(this).parents('.svl-upload-image');
		    parentDiv.removeClass('has-image');
		    parentDiv.find('input[type="hidden"]').val('');
		    return false;
		  });
		})(jQuery);
		</script>
		<?php
	}
	
	function hotline_to_footer(){
		$hotline_options = wp_parse_args(get_option($this->_optionName),$this->_defaultOptions);
		$active = isset($hotline_options['active']) ? $hotline_options['active'] : '';
		$avatar = isset($hotline_options['avatar']) ? $hotline_options['avatar'] : '';
		$text = isset($hotline_options['text']) ? $hotline_options['text'] : '';
        $scrolltop = isset($hotline_options['scrolltop']) ? $hotline_options['scrolltop'] : 0;
		if(!$active || $active != 1) return;
		?>
		<style>
.hotline_close,.hotline_container{cursor:pointer}.hotline_wrap{text-align:left;position:fixed;bottom:20px;right:70px;background:#fff;line-height:1.4;padding:10px;border-radius:5px;max-width:392px;width:392px;height:auto;z-index:1000;border:5px solid #51B4D3;opacity:0;visibility:hidden}.hotline_wrap.showAfterScroll{opacity:1;visibility:visible}.hotline_container img{float:left;position:absolute;left:-60px;top:-12px;border-radius:50%;border:5px solid #51B4D3;max-width:100px;max-height:100px}.hotline_text{max-width:309px;float:right;margin-top:5px;color:#000;font-size:16px}.hotline_close{position:absolute;top:-15px;right:-14px;text-align:center;width:24px;line-height:16px;background:#fff;color:#2bb0e8;border:3px solid #2bb0e8;border-radius:50%;font-size:15px;padding-bottom:2px}@media (max-width:500px){.hotline_wrap{width:90%;right:18px;max-width:100%}.hotline_container img{display:none}.hotline_text{margin:0}}
		</style>
		<div class="hotline_wrap">
			<div class="hotline_container">
				<?php if($avatar):?><?php echo wp_get_attachment_image($avatar,'full')?><?php endif;?>
				<?php if($text):?><div class="hotline_text"><?php echo $text;?></div><?php endif;?>				
			</div>	
			<div class="hotline_close">x</div>
		</div>
		<script>
		(function($){
			$(document).ready(function(){
				$('.hotline_close').on('click',function(){
					$('.hotline_wrap').fadeOut();
				});
				$(window).scroll(function () {
                   var thisScrollTop = $(window).scrollTop();
                   var thisWrap = $('.hotline_wrap');
                   if(!thisWrap.hasClass('showAfterScroll')){
                       if(thisScrollTop >= parseInt(<?php echo $scrolltop;?>)){
                           thisWrap.addClass('showAfterScroll');
                       }
                   }
                });
			});
		})(jQuery);
		</script>
		<?php
	}
}
new devvn_hotline;
}