<?php
/**
 * Flatsome functions and definitions
 *
 * @package flatsome
 */

require get_template_directory() . '/inc/init.php';


//xoa header
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'wp_shortlink_wp_head');
remove_action( 'wp_head', 'feed_links', 2 ); 
remove_action('wp_head', 'feed_links_extra', 3 );
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head');
remove_action( 'wp_head', 'wp_resource_hints', 2 );
//tat api json
function remove_api () {
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
}
add_action( 'after_setup_theme', 'remove_api' );
//xoa chao mung dashboard
remove_action('welcome_panel', 'wp_welcome_panel');
// xoa string
function _remove_script_version( $src ){
$parts = explode( '?ver', $src );
return $parts[0];
}
add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );

// Tat XML-RPC chong hack
function remove_x_pingback($headers) {
    unset($headers['X-Pingback']);
    return $headers;
}
add_filter('wp_headers', 'remove_x_pingback');
add_filter('xmlrpc_enabled', '__return_false');
// tắt sửa plugins và themes
define('DISALLOW_FILE_EDIT',true);
@ini_set('display_errors', 0);

// tắt upload plugins và themes
function __block_caps( $caps, $cap )
{
    if ( $cap === 'upload_plugins' || $cap === 'install_themes')
        $caps[] = 'do_not_allow';
    return $caps;
}
add_filter( 'map_meta_cap', '__block_caps', 10, 2 );


/**
 * Tat emoji's
 */
function disable_emojis() {
        remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
        remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
        remove_action( 'wp_print_styles', 'print_emoji_styles' );
        remove_action( 'admin_print_styles', 'print_emoji_styles' );    
        remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
        remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );      
        remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
        add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
}
add_action( 'init', 'disable_emojis' );
function disable_emojis_tinymce( $plugins ) {
        if ( is_array( $plugins ) ) {
                return array_diff( $plugins, array( 'wpemoji' ) );
        } else {
                return array();
        }
}
// Tat nhung embed
function speed_stop_loading_wp_embed() {
if (!is_admin()) {
wp_deregister_script('wp-embed');
}
}
add_action('init', 'speed_stop_loading_wp_embed');
// top menu
function remove_admin_bar_links() {
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('wp-logo');          /** Remove the WordPress logo **/
    $wp_admin_bar->remove_menu('about');            /** Remove the about WordPress link **/
    $wp_admin_bar->remove_menu('flatsome_panel');   /** Remove the updates link **/
	 $wp_admin_bar->remove_menu('flatsome-activate');   
}
add_action( 'wp_before_admin_bar_render', 'remove_admin_bar_links' );
//Limit words
function greenweb_string_limit($string, $word_limit)
{
$words = explode(' ', $string, ($word_limit + 1));
if(count($words) > $word_limit) {
array_pop($words);
}
return implode(' ', $words);
}

add_action('get_header', 'remove_admin_login_header');
function remove_admin_login_header() {
	remove_action('wp_head', '_admin_bar_bump_cb');
}
// tắt thông báo cập nhật với user
   global $user_login;
   get_currentuserinfo();
   if (!current_user_can('update_plugins'))
   {
        // checks to see if current user can update plugins
           add_action( 'init', create_function( '$a', "remove_action( 'init', 'wp_version_check' );" ), 2 );
           add_filter( 'pre_option_update_core', create_function( '$a', "return null;" ) );
   }
 // thêm menu
function add_menu_admin_bar_link() {
 global $wp_admin_bar;
 $args = array('id' => 'menu_id','title' => __('Quản lí khác'),'href' => __('options-general.php'),);
 $wp_admin_bar->add_node( $args );
 
 $args = array('id' => 'child_menu1_id','title' => 'Block','href' => __('edit.php?post_type=blocks'), 'parent'=> 'menu_id'); 
 $wp_admin_bar->add_node( $args );
  $args = array('id' => 'child_menu2_id', 'title' => 'Lưu cấu hình và khôi phục', 'href' => __('admin.php?page=optionsframework&tab#of-option-backupandimport'),'parent'=> 'menu_id');
 $wp_admin_bar->add_node( $args );
}
add_action('admin_bar_menu', 'add_menu_admin_bar_link',81);
function custom_toolbar_link($wp_admin_bar) {
    $args = array(
        'id' => 'flatsome',
        'title' => 'Cài đặt cấu hình', 
        'href' => 'admin.php?page=optionsframework&tab', 
        'meta' => array(
            'class' => 'greensetting', 
            'title' => 'Cài đặt tổng quan'
            )
    );
    $wp_admin_bar->add_node($args);
}
add_action('admin_bar_menu', 'custom_toolbar_link', 999);
/** xóa menu cho đơn giản**/
function remove_menus(){
remove_menu_page('edit-comments.php');
remove_menu_page( 'flatsome-panel' );
remove_menu_page('edit.php?post_type=blocks');  

}
add_action( 'admin_menu', 'remove_menus' );

/** sửa css admin**/
add_action('admin_head', 'my_custom_fonts');
function my_custom_fonts() {
  echo '<style>
   li#toplevel_page_mega_main_menu_options {
    display: none;
}
  </style>';
}
/** post greeweb**/

//post greenweb
add_shortcode('posts_shortcode', 'create_posts_shortcode');
if(!function_exists( 'create_posts_shortcode' )) {
	function create_posts_shortcode ( $ts ) {
		$number_post = $ts['number_post'];
		$layout_style = $ts['layout_style'];
		$categories = $ts['categories'];

		if(strlen( $number_post ) <= 0 || intval($number_post) <= 0 ) {
			$number_post = '-1';
		}
		/*if($number_post != '-1') {
			$number_post = intval($number_post) - 1;
		}*/

		$args = array(
			'posts_per_page' => $number_post,
			'post_type' => 'post',
			'orderby' => 'date',
			'order' => 'DESC',
			'post_status' => 'publish'
		);
		if ($categories != '') {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'category',
					'field' => 'slug',
					'terms' => explode(',', $categories),
					'operator' => 'IN'
				)
			);
		}

		$data = new WP_Query($args);
		$i = 0;
		$shortcode_content = '';
		if ($data->have_posts()) {
			$shortcode_content.='<ul class="posts-shortcode clearfix '.$layout_style.'">';
				while ($data->have_posts()) {
					$data->the_post();
					$item_class = '';
					$attach_id  = get_post_thumbnail_id();
					$image_src  = null;
					$excerpt    = '';
					if ( $i == 0 ) {
						$item_class .= 'first-news';
						$excerpt   = get_the_excerpt();
						$image_src = wp_get_attachment_image_src( $attach_id, 'full' );
						if ( empty( $excerpt ) ) {
							$excerpt = substr_except( the_content(), 180, '...' );
						} else {
							$excerpt = substr_except( $excerpt, 180, '...' );
						}
					} else {
						$item_class .= 'other-news clearfix';
						$image_src = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
					}
					if ( sizeof( $image_src ) > 0 ) {
						$image_src = $image_src[0];
					}
					$shortcode_content .= '<li class="' . $item_class . '">';
					$shortcode_content .= '<div class="inner-content">';
					if ( ! empty( $image_src ) ) {
						$shortcode_content .= '<div class="post-thumbnail tie-appear" >';
						$shortcode_content .= '<a href = "' . get_the_permalink() . '" title = "' . get_the_title() . '" >';
						$shortcode_content .= '<img src = "' . $image_src . '" class="tie-appear" >';
						$shortcode_content .= '</a >';
						$shortcode_content .= '</div >';
					} else {
						$shortcode_content .= '<div class="no-image" ><span > NO IMAGE </span ></div >';
					}
					$shortcode_content .= '<h2 class="post-box-title">';
					$shortcode_content .= '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '">' . get_the_title() . '</a>';
					$shortcode_content .= '</h2>';
					$shortcode_content .= '<p class="post-meta"></p>';
					if ( $layout_style == 'left-right' && $i == 0 ) {
						$shortcode_content .= '<div class="entry">';
						$shortcode_content .= '<p>' . $excerpt . '</p>';
						
						$shortcode_content .= '</div>';
					}
					$shortcode_content .= '</div>';
					$shortcode_content .= '</li>';
					$i ++;
				}
			$shortcode_content.='</ul>';
		}
		return $shortcode_content;
		wp_reset_postdata();
	}
}

if(!function_exists( 'substr_except' )) {
	function substr_except($str, $txt_len, $end_txt) {
		if (empty($str)) return '';
		if (strlen($str) <= $txt_len) return $str;
		$i = $txt_len;
		while ($str[$i] != ' ') {
			$i--;
			if ($i == -1) break;
		}
		while ($str[$i] == ' ') {
			$i--;
			if ($i == -1) break;
		}

		return substr($str, 0, $i + 1) . $end_txt;
	}
}
/** xóa tin tức dashboard **/
function remove_dashboard_widgets() {
	global $wp_meta_boxes;

	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
	
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_drafts']);
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
}
add_action('wp_dashboard_setup', 'remove_dashboard_widgets' );
/** xóa thanh toán**/
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
function custom_override_checkout_fields( $fields ) {
     unset($fields['billing']['billing_postcode']);
	 unset($fields['billing']['billing_address_2']);
	  unset($fields['billing']['billing_city']);
	 unset($fields['billing']['billing_country']);
	 unset($fields['billing']['billing_state']);
	 unset($fields['billing']['billing_company']);
     return $fields;
}
/**xóa yêu cầu ô nhập**/

function sv_unrequire_wc_phone_field( $fields ) {
    $fields['billing_email']['required'] = false;
	 $fields['billing_first_name']['required'] = false;
    return $fields;
}
add_filter( 'woocommerce_billing_fields', 'sv_unrequire_wc_phone_field' );
// remove Order Notes from checkout field in Woocommerce
add_filter( 'woocommerce_checkout_fields' , 'alter_woocommerce_checkout_fields' );
function alter_woocommerce_checkout_fields( $fields ) {
     unset($fields['order']['order_comments']);
     return $fields;
}

// thêm notes
 
function notice_shipping() {
echo '<p class="locdatok"><b style="color: #ef0000;">Lưu ý : </b> Email và họ có thể để trống, mục có dấu * là bắt buộc nhập.</p>';
}
add_action( 'woocommerce_before_order_notes', 'notice_shipping' );
// also removes Order Notes Title
add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );

//tang toc google speed -> cho js xuong duoi cung
function remove_head_scripts() { 
   remove_action('wp_head', 'wp_print_scripts'); 
   remove_action('wp_head', 'wp_print_head_scripts', 9); 
   remove_action('wp_head', 'wp_enqueue_scripts', 1);
 
   add_action('wp_footer', 'wp_print_scripts', 5);
   add_action('wp_footer', 'wp_enqueue_scripts', 5);
   add_action('wp_footer', 'wp_print_head_scripts', 5); 
} 
add_action( 'wp_enqueue_scripts', 'remove_head_scripts' );
